'-------------------------------------------------------------------------------
'Developer                : Abhishek kumar
'Name of code file        : heartbeatmeter.bas
'Copyright                : (c) 1992-2011, Abhishek Smart Devices
'Purpose                  : HeartBeat-Meter with Logger (Sync with PC)
'Micro                    : AT89S52
'Commercial addon needed  : no
'Use in simulator         : possible
'-------------------------------------------------------------------------------
'*******************************************************************************
$regfile = "89c55wd.dat"
$crystal = 3579545                                            '16.9344 MHz crystal
$baud = 9600                                                  'serialport baudrate
'$sim
'****************************** Port Initialisations ***************************
P0 = 255
'     |
'     |
'     *------->Port 0,connected to all pins of 7 segment display (write 0 to enable all)
P1 = &B11111001
'      ||||||||
'      |||||||*->(P1.0) Switch A==SELECT MODE / START
'      ||||||*--->(P1.1)
'      |||||*----->(P1.2) Sensor Enable Pin(write 1 to enable it)
'      ||||*------->(P1.3) Started LED(write 0 to enble it)
'      |||*--------->(P1.4) Stopped LED(write 0 to enble it)
'      ||*----------->(P1.5) Serial Programming Pin
'      |*------------->(P1.6) Serial Programming Pin
'      *--------------->(P1.7) Serial Programming Pin
P2 = &B11101111
'      ||||||||
'      |||||||*->(P2.0) Hundredth Place enable 7segment pin(write 0 to enble it)
'      ||||||*--->(P2.1) Tenth Place enable 7segment pin(write 0 to enble it)
'      |||||*----->(P2.2) Oneth Place enable 7segment pin(write 0 to enble it)
'      ||||*------->(P2.3) Vibrator Motor(write 0 to enble it)
'      |||*--------->(P2.4) Buzzer
'      ||*----------->(P2.5) Green LED(write 0 to enble it)
'      |*------------->(P2.6) Yellow LED(write 0 to enble it)
'      *--------------->(P2.7) Red LED(write 0 to enble it)
P3 = &B00001111
'      ||||||||
'      |||||||*->(P3.0) [RXD]
'      ||||||*--->(P3.1) [TXD]
'      |||||*----->(P3.2) [INT0] Pulse in from Sensor
'      ||||*------->(P3.3) [INT1] Switch B==OK / Stop Process
'      |||*--------->(P3.4)
'      ||*----------->(P3.5)
'      |*------------->(P3.6)
'      *--------------->(P3.7)
'*******************************************************************************
Declare Sub Countstart                                        'start process
'*********************** Declaring constants fof 7 segment display *************
'Assigned constants consume no program memory
'The compiler will replace all occurrences of the symbol with the assigned value
Const Zero = 136
Const One = 187
Const Two = 148
Const Three = 145
Const Four = 163
Const Five = 193
Const Six = 192
Const Seven = 155
Const Eight = 128
Const Nine = 129
'*******************************************************************************
'Numbers to write to PORT0--> 7 segment dislay is connected to port0
'Number           Decimal code
'------           ------------
'  0---------------> 136
'  1---------------> 187
'  2---------------> 148
'  3---------------> 145
'  4---------------> 163
'  5---------------> 193
'  6---------------> 192
'  7---------------> 155
'  8---------------> 128
'  9---------------> 129
'*******************************************************************************
Const Onon = 0                                                'used for switching ON led's and vibrator motor,etc
Const Offoff = 1                                              'used for switching OFF led's and vibrator motor,etc
'****************************** port initialisations and aliases ***************
Sensor Alias P1.2                                             'sensor enable/disable control
Greenled Alias P2.5                                           'Green LED
Yellowled Alias P2.6                                          'Yellow LED
Redled Alias P2.7                                             'Red LED
Buzzer Alias P2.4                                             'Buzzer
Vibrator Alias P2.3                                           'Vibration actuator
Startedled Alias P1.3                                         'Process-"Started" LED
Stoppedled Alias P1.4                                         'Process-"Stopped" LED
'**************************** Timers *****************************************************************************************
'The timer/counter can operate in four modes:
' mode 0 : 13-bit counter.
'An interrupt is generated when the counter overflows. So it takes 8192 pulses to generate the next interrupt.
' mode 1 : 16-bit counter.
'Mode 1 is similar to mode 0. It implements a 16-bit counter.
'It takes 65536 input pulses to generate the next interrupt.
'. mode 2 : 8-bit auto reload.
'TL0 serves as an 8-bit timer/counter.
'When The Timer / Counter Overflows The Number Stored In Th0 Is Copied Into Tl0 And The Count Continues.
'An Interrupt Is Generated Each Time The Counter Overflows And A Reload Is Performed.
' mode 3 : TIMER1 is inactive and holds its count. (TIMER1).
'For TIMER0 in timer mode two 8-bit timers are available and in counter mode one 8-bit timer is available.
'See a datasheet for more details.
'---------------------------------
'The timer/counter can also be controlled with the alternative pin P3.2.
'This pin is labeled for its alternative INT0-input but it can be used to control the timer.
'When GATE is reset the timer/counter is enabled.
'When GATE is set the timer/counter is enabled if INT0 is active(low). (provided that the timer is started)
'-------------------------------------------------
Config Timer0 = Timer , Mode = 1 , Gate = Internal            'timer0 is used for generating 15 second delay for heartbeat counting period (16 bit mode)
'-------------------------------------------------
Config Timer1 = Timer , Mode = 2 , Gate = Internal            'timer1 is used for 7segment display multiplexing algorithm (8 bit mode)
'-------------------------------------------------
Config Timer2 = Timer , Mode = 2 , Gate = Internal            'timer2 is used as baud rate generator now ; mode-2 has different meaning in timer2
'-------------------------------------------------
'SET TCON.0 ---- Falling edge generates interrupt for INT0.
'RESET TCON.0 ---- Low signal generates interrupt for INT0.
'SET TCON.2 ---- Falling edge generates interrupt for INT1.
'RESET TCON.2 ---- Low signal generates interrupt for INT1.

Enable Interrupts                                             'enable global inturrupts
Enable Timer0                                                 'enable timer0 for time management
Enable Timer1                                                 'enable timer1 for 7 segment multiplexing

Set Tcon.0                                                    'make INT0 to occur at falling edge of pulse from sensor

Disable Int0                                                  'disable sensor count input at startup
'---------------- ISR Links ----------------------
On Timer0 Timemgmt                                            'timer0 ISR
On Timer1 Displaycode                                         'timer1 ISR
On Int0 Countsensor                                           'INT0 ISR
'-------------------------------------------------
Stop Timer0                                                   'stop time management service at startup
'*********************************************************** Variables *********
'Elementary Data Types
'Bit  (1/8 byte)
' Byte (1 byte)
'Bytes are stores as unsigned 8-bit binary numbers ranging in value from 0 to 255.
' Integer (two bytes).
'Integers are stored as signed sixteen-bit binary numbers ranging in value from  -32,768 to +32,767.
' Word (two bytes).
'Words are stored as unsigned sixteen-bit binary numbers ranging in value from  0 to 65535.
' Long (four bytes).
'Longs are stored as signed 32-bit binary numbers ranging in value from  -2147483648 to 2147483647.
' Single
'Singles are stored as signed 32 bit binary numbers.
' String (up to 254 bytes).
'Strings are stored as bytes and are terminated with a 0-byte.
'A string dimensioned with a length of 10 bytes will occupy 11 bytes.
Dim Abuff As Byte                                             'serial input buffer load variable

Dim Limit As Word                                             'time <mode-selected> variable
Limit = 68                                                    'value for 15 sec time mode as default

Dim T As Word                                                 'time counting variable

Dim A As Byte , P As Byte , Q As Byte , R As Byte , S As Byte       '7segment multiplexing variables

Dim X As Byte                                                 'heart beat count variable
Dim G As Byte                                                 'actual heartbeat

Dim Choice As Byte                                            'for mode select
Choice = 15                                                   'default 15 sec mode
'******************************************************************************************************************************

Start Timer1                                                  'switch on 7segment display,let user select the test mode

'############### Let user select the operating mode-15/30/60 seconds ###########
Do
          G = Choice                                          'assign to "G" the choice variable because 7 segment decoding function use only "G" to decode

          If P1.0 = 0 Then                                    'Switch A pressed

                If Choice = 15 Then                           '---if 15 sec mode selected previously---
                Choice = Choice + 15                          'set it to 30 sec mode on button press
                Limit = 136                                   'set limit variables with appropriate time limit variable
                Elseif Choice = 30 Then                       '---if 30 sec mode selected previously---
                Choice = Choice + 30                          'set it to 60 sec mode on button press
                Limit = 273                                   'set limit variables with appropriate time limit variable
                Elseif Choice = 60 Then                       '---if 60 sec mode selected previously---
                Choice = 15                                   'set it to 15 sec mode on button press
                Limit = 68                                    'set limit variables with appropriate time limit variable
                End If

                Waitms 200
          End If

          If P3.3 = 0 Then                                    'switch B pressed
                Stop Timer1                                   'stop the 7segment display
                P0 = 255                                      'blank out the 7 segment data lines port
                Exit Do                                       'exit this forever do loop
          End If

Loop
'###############################################################################

Wait 1                                                        'wait one second
Stoppedled = Onon                                             'switch ON stopped LED
Sound Buzzer , 1000 , 40                                      'beep to tell the user that selected mode has been assigned and test process can be started,device is ready now

'*******************************************************************************
'*******************************************************************************
'*******************************************************************************
'********************************* Main Loop ***********************************
'******************************* Infinite Loop *********************************

Do

'-----------------------------
If P1.0 = 0 Then                                              'switch A Pressed
        Choice = 1                                            'set choice=1,this will be used to wait 4 sec before start button is pressed of device
        Call Countstart                                       'call process start function
End If
'-----------------------------
Abuff = Inkey()                                               'look for a character in the serial buffer input

If Abuff = 84 Then                                            'received character T from input to test whether hardware is connected or not
   Waitms 500
   Print "S"                                                  'send back "S" and tell that hardware is present
End If

If Abuff = 65 Then                                            'A is received,15 sec mode
  Limit = 68
  Choice = 2                                                  'this will be used to enable the instant start on serial input feature,without delaying 4 seconds
  Call Countstart
End If

If Abuff = 66 Then                                            'B is received,30 sec mode
  Limit = 136
  Choice = 2                                                  'this will be used to enable the instant start on serial input feature,without delaying 4 seconds
  Call Countstart
End If

If Abuff = 67 Then                                            'C is received,60 sec mode
  Limit = 273
  Choice = 2                                                  'this will be used to enable the instant start on serial input feature,without delaying 4 seconds
  Call Countstart
End If

If Abuff = 88 Or P3.3 = 0 Then                                'X is received,stop everything now
        Stop Timer0                                           'stop timer0 if it is already running
        Stop Timer1                                           'stop 7sement display procedure
        Disable Int0                                          'disable pulse counting
        Reset Sensor                                          'diable sensor
        P0 = 255
        X = 0                                                 'reset pulse count variale
        G = 0                                                 'reset heartbeat
        T = 0                                                 'reset time variable
        Startedled = Offoff                                   'switch off the started led
        Stoppedled = Onon                                     'switch on the stopped led
        Sound Buzzer , 1000 , 40
End If
'-----------------------------

Loop
End
'*******************************************************************************
'*******************************************************************************
'*******************************************************************************
'*******************************************************************************
'********************** 7 segment decoding *************************************
Displaycode:                                                  'timer0 ISR
'-------main digit place decoding algo----
P = G Mod 10                                                  '3
Q = G \ 10                                                    '12
R = Q Mod 10                                                  '2
S = Q \ 10                                                    '1
'------------------------------------------
If A = 0 Then                                                 'that is oneth place is to be decoded here
                 P0 = 255                                     'fully reset the port0,before loading any data

                 P2.0 = 1                                     'reset the 7sgment select pins also
                 P2.1 = 1                                     'reset the 7sgment select pins also
                 P2.2 = 1                                     'reset the 7sgment select pins also

                 Select Case P

                   Case 0 : P0 = Zero
                   Case 1 : P0 = One
                   Case 2 : P0 = Two
                   Case 3 : P0 = Three
                   Case 4 : P0 = Four
                   Case 5 : P0 = Five
                   Case 6 : P0 = Six
                   Case 7 : P0 = Seven
                   Case 8 : P0 = Eight
                   Case 9 : P0 = Nine

                 End Select

                 P2.2 = Onon                                  'enable oneth place 7 segment data load
Elseif A = 5 Then                                             'that is tenth place is to be decoded here
                P0 = 255                                      'fully reset the port0,before loading any data

                P2.0 = 1                                      'reset the 7sgment select pins also
                P2.1 = 1                                      'reset the 7sgment select pins also
                P2.2 = 1                                      'reset the 7sgment select pins also

                Select Case R

                  Case 0 : P0 = Zero
                  Case 1 : P0 = One
                  Case 2 : P0 = Two
                  Case 3 : P0 = Three
                  Case 4 : P0 = Four
                  Case 5 : P0 = Five
                  Case 6 : P0 = Six
                  Case 7 : P0 = Seven
                  Case 8 : P0 = Eight
                  Case 9 : P0 = Nine

                End Select

                P2.1 = Onon                                   'enable tenth place 7 segment data load
Elseif A = 10 Then                                            'that is hundredth place is to be decoded here
                P0 = 255                                      'fully reset the port0,before loading any data

                P2.0 = 1                                      'reset the 7sgment select pins also
                P2.1 = 1                                      'reset the 7sgment select pins also
                P2.2 = 1                                      'reset the 7sgment select pins also

                Select Case S

                  Case 0 : P0 = Zero
                  Case 1 : P0 = One
                  Case 2 : P0 = Two
                  Case 3 : P0 = Three
                  Case 4 : P0 = Four
                  Case 5 : P0 = Five
                  Case 6 : P0 = Six
                  Case 7 : P0 = Seven
                  Case 8 : P0 = Eight
                  Case 9 : P0 = Nine

                End Select

                P2.0 = Onon                                   'enable hundredth place 7 segment data load
End If

Incr A

If A > 15 Then
A = 0
End If

Return
'******************************* time delay ************************************
Timemgmt:
Incr T
'-----------------------------
If T = Limit Then                                             'i.e. time is completed now
      Disable Int0                                            'disable sensor count input
      Reset Sensor                                            'disable the sensor now
      Stop Timer0                                             'stop timer0 now

      X = X - 1                                               'decrement count by one (error removal)

      Startedled = Offoff
      Stoppedled = Onon


      Vibrator = Onon                                         'switch ON vibrator
      Sound Buzzer , 600 , 40                                 'Beep sound
      Waitms 500
      Sound Buzzer , 1200 , 40                                'Beep sound
      Waitms 500
      Vibrator = Offoff                                       'switch OFF vibrator

      If Limit = 68 Then
      G = 4 * X                                               'calculation of actual heartbeat ie 4 times the counted variable X
      End If

      If Limit = 136 Then
      G = 2 * X                                               'calculation of actual heartbeat ie 2 times the counted variable X
      End If

      If Limit = 273 Then
      G = X                                                   'calculation of actual heartbeat ie the counted variable X
      End If

      Print "F" ; G ; "Z"                                     'tell pc software to empty a textbox # send the heartbeat data # tell pc software that transmission of data has been completed

      Start Timer1                                            'now switch on the 7 segment display and show the results
End If
'------------------------------
Return
'*******************************************************************************
Countsensor:                                                  'INT0 sensor counting routine
Incr X                                                        'increment "X" by 1 foe every pulse detected
Waitms 300                                                    'it is mandatorary to wait for few seconds until next pulse comes,to minimise spurious signals
Return
'*******************************************************************************
Sub Countstart                                                'when "START" button is pressed

Vibrator = Offoff                                             'stop vibrator if it was ON
Stoppedled = Offoff                                           'switch OFF stopped LED if it was ON previously,because the process is starting now

Stop Timer1                                                   'stop 7 segment display also
Stop Timer0                                                   'stop timer0 if it is already running
P0 = 255                                                      'zero port0 to blank the 7 segment display

X = 0                                                         'everytime initialisation for counting to start when "START" button is pressed
T = 0                                                         'everytime initialisation for counting to start when "START" button is pressed

If Choice = 1 Then                                            'if start button,A is pressed
    'wait 4 seconds before starting and let the user place his finger correctly
    Redled = Onon
    Wait 1
    Yellowled = Onon
    Wait 1
    Greenled = Onon
    Wait 1
    Redled = Offoff
    Yellowled = Offoff
    Greenled = Offoff                                         'reset all LEDs
    Wait 1
End If

Startedled = Onon                                             'switch ON the started LED
Start Timer0                                                  'start 15 sec timer
Set Sensor                                                    'enable the sensor
Enable Int0                                                   'enable sensor count input

End Sub
'*******************************************************************************